package com.beiming.odr.consultancy.enums;

/**
 * @Description:咨询状态查询枚举类型
 * @Author: chenjt
 * @Date: Created 2018/7/3
 */
public enum DisputeQueryStatusEnum {

  USER_LIST("用户个人咨询列表"),
  WAITING_ACCPET("客服未受理"),
  CUSTOMER_ACCPET("客服受理未结束"),
  CUSTOMER_ACCPET_END("客服受理已结束"),
  OTHER_CUSTOMER_ACCPET("他人受理"),
  COUNSELOR_ACCPET("咨询师受理中"),
  END_COUNSELOR("咨询师受理结束");

  private String name;

  DisputeQueryStatusEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static boolean isExistStatus(String code) {
    for (DisputesProgressEnum d : DisputesProgressEnum.values()) {
      if (d.name().equals(code)) {
        return true;
      }
    }
    return false;
  }
}


