/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.consultancy.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyHttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(MyHttpClientUtils.class);
    private static String encoding = "UTF-8";
    private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();

    public static String sendHttpDelete(String httpUrl, Map<String, String> header) throws IOException {
        HttpDelete httpDelete = new HttpDelete(httpUrl);
        if (header != null) {
            Set<String> keys = header.keySet();
            for (String key : keys) {
                httpDelete.setHeader(key, header.get(key));
            }
        }
        return MyHttpClientUtils.sendHttpDelete(httpDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpDelete(HttpDelete httpDelete) throws IOException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.createDefault();
            httpDelete.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpDelete);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)encoding);
        }
        catch (Exception e) {
            log.error("GoshawkHttpClientUtils sendHttpGet error {}", (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return responseContent;
    }

    public static String sendHttpPost(String httpUrl) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        return MyHttpClientUtils.sendHttpPost(httpPost);
    }

    public static String sendHttpPost(String httpUrl, String json) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        return MyHttpClientUtils.sendHttpPost(httpPost);
    }

    public static String sendHttpPostAuthorization(String httpUrl, String json, String authorization) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        httpPost.setHeader("authorization", authorization);
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        return MyHttpClientUtils.sendHttpPost(httpPost);
    }

    public static String sendHttpPost(String httpUrl, String json, Map<String, String> header) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        for (String key : header.keySet()) {
            httpPost.setHeader(key, header.get(key));
        }
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        return MyHttpClientUtils.sendHttpPost(httpPost);
    }

    public static String sendHttpPost2(String httpUrl, String json, Map<String, String> header) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        for (String key : header.keySet()) {
            httpPost.setHeader(key, header.get(key));
        }
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_FORM_URLENCODED));
        return MyHttpClientUtils.sendHttpPost(httpPost);
    }

    public static String sendHttpPost(String httpUrl, Map<String, String> maps) throws IOException {
        HttpPost httpPost = new HttpPost(httpUrl);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (String key : maps.keySet()) {
            nameValuePairs.add(new BasicNameValuePair(key, maps.get(key)));
        }
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, encoding));
        }
        catch (Exception e) {
            log.error("MyHttpClientUtils sendHttpPost error {}");
        }
        return MyHttpClientUtils.sendHttpPost(httpPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpPost(HttpPost httpPost) throws IOException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.createDefault();
            httpPost.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpPost);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)encoding);
        }
        catch (Exception e) {
            log.error("MyHttpClientUtils sendHttpPost error {}", (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return responseContent;
    }

    public static String sendHttpGet(String httpUrl) throws IOException {
        HttpGet httpGet = new HttpGet(httpUrl);
        return MyHttpClientUtils.sendHttpGet(httpGet);
    }

    public static String sendHttpsGet(String httpUrl) throws IOException {
        HttpGet httpGet = new HttpGet(httpUrl);
        return MyHttpClientUtils.sendHttpsGet(httpGet);
    }

    public static String sendHttpGet(String httpUrl, Map<String, String> header) throws IOException {
        HttpGet httpGet = new HttpGet(httpUrl);
        if (header != null) {
            Set<String> keys = header.keySet();
            for (String key : keys) {
                httpGet.setHeader(key, header.get(key));
            }
        }
        return MyHttpClientUtils.sendHttpGet(httpGet);
    }

    public static String sendHttpsGet(String httpUrl, Map<String, String> header) throws IOException {
        HttpGet httpGet = new HttpGet(httpUrl);
        if (header != null) {
            Set<String> keys = header.keySet();
            for (String key : keys) {
                httpGet.setHeader(key, header.get(key));
            }
        }
        return MyHttpClientUtils.sendHttpsGet(httpGet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpsGet(HttpGet httpGet) throws IOException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactory.getSocketFactory()).setDefaultRequestConfig(requestConfig).build();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)encoding);
        }
        catch (Exception e) {
            log.error("MyHttpClientUtils sendHttpsGet error {}", (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return responseContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpGet(HttpGet httpGet) throws IOException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.createDefault();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)encoding);
        }
        catch (Exception e) {
            log.error("MyHttpClientUtils sendHttpGet error {}", (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return responseContent;
    }
}

