package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.dto.TagConfigPageDTO;
import com.beiming.odr.referee.dto.requestdto.TagConfigDTO;
import java.util.ArrayList;

public interface TagConfigApi {

  /**
   * 新增或更新
   *
   * @param req
   * @return
   */
  DubboResult upsert(TagConfigDTO req);


  /**
   * 根据ID 或type及code查询一个配置值
   *
   * @param req
   * @return
   */
  DubboResult<TagConfigDTO> getOneValue(TagConfigDTO req);


  /**
   * 分页查询
   *
   * @param req
   * @return
   */
  DubboResult<PageInfo<TagConfigDTO>> getPageValue(TagConfigPageDTO req);


  /**
   * 根据type查询一组配置值
   *
   * @param req
   * @return
   */
  DubboResult<ArrayList<TagConfigDTO>> getListByType(TagConfigDTO req);


}
