package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 保存调解笔录的请求对象
 * 
 * @author DJQ 2018年6月26日
 *
 */
@Data
public class MediationRecordSaveReqDTO implements Serializable {

  private static final long serialVersionUID = -2629252493346421363L;

  private Long documentId; // ID
  @NotNull(message = "{conference.id.cannot.be.empty}")
  private Long meetingId;
  private Long lawCaseId;
  private String caseNo; // 案件号
  private String disputeType; // 纠纷类型
  private String content; // 笔录内容
  private String location; // 地点
  private String startTime; // 开始时间
  private String endTime; // 开始时间
  @NotNull(message = "{parameter.record.remark.null}")
  private String remark; // 备注
  private List<MediationPersonalReqDTO> mediationParticipants; // 会议参与人信息（调解员）
  private Long currentUserId; //当前token代表的用户id

}
