package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 签名请求的基础信息参数
 * 
 * @author DJQ 2018-07-05
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SignatureInfoReqDTO implements Serializable {

  private static final long serialVersionUID = -2185513732200103145L;

  @NotNull(message = "{user.id.cannot.be.empty}")
  private Long userId; // 用户ID
  @NotNull(message = "{document.id.cannot.be.empty}")
  private Long documentId; // 文书ID
  @NotNull(message = "{parameter.img.id.null}")
  private String imgId; // 图像文件ID
  @NotNull(message = "{parameter.img.degree.null}")
  private Integer degree; // 旋转度数90，180，270
//  @NotNull(message = "{parameter.esign.accountid.null}")
  private String accountId; //e签宝用户id

  public SignatureInfoReqDTO(Long userId, Long documentId, String imgId, Integer degree) {
    this.userId = userId;
    this.documentId = documentId;
    this.imgId = imgId;
    this.degree = degree;
  }
}
