package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description 距调解期限倒计时3天的案件数据项
 * @Author blake
 * @Date 2020/5/12 4:26 下午
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EncryptDecryptData
public class LawCaseCountDownResDTO implements Serializable {

  private static final long serialVersionUID = -3031422536094614808L;

  private Long lawCaseId;

  @EncryptDecryptField
  private String caseNo;

  private Date mediationDeadline;

  private Long mediatorId;

  private String disputeType;

  private String disputeTypeCode;

  private String orgName;
}
