package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description: 定时任务,取得每天的分类调解案件数量统计
 * @Date: Created 2018-07-18 21:31
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LawCaseEveryDayResDTO implements Serializable {

  private static final long serialVersionUID = -430551116932145457L;
  /**
   * 统计数量
   */
  private Integer num;

  /**
   * 统计日期
   */
  private String happenDate;

  /**
   * 纠纷类别code
   */
  private String disputeTypeCode;

  /**
   * 纠纷类别名称
   */
  private String disputeTypeName;

  /**
   * 统计机构id
   */
  private String orgId;

  /**
   * 统计机构名称
   */
  private String orgName;

  /**
   * 统计机构地区代码
   */
  private String orgAreaCode;

  /**
   * 调解案件成功数量
   */
  private Integer caseSuccessCount;

  /**
   * 调解案件失败数量
   */
  private Integer caseFailCount;

  /**
   * 诉讼案件数量
   */
  private Integer suitCount;

  /**
   * 司法确认案件数量
   */
  private Integer judicialCount;

}
