package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.DossierFileDeleteDTO;
import com.beiming.odr.referee.dto.JudicialFileDeleteDTO;
import com.beiming.odr.referee.dto.requestdto.AgentAuthorizeProxyReqDTO;
import com.beiming.odr.referee.dto.requestdto.AttachmentReqDTO;
import com.beiming.odr.referee.dto.requestdto.AuthorizeProxyReqDTO;
import com.beiming.odr.referee.dto.requestdto.BatchFilesReqDTO;
import com.beiming.odr.referee.dto.requestdto.DocumentSignReqDTO;
import com.beiming.odr.referee.dto.requestdto.EvidenceOppugnReqDTO;
import com.beiming.odr.referee.dto.requestdto.GDBatchFilesReqDTO;
import com.beiming.odr.referee.dto.responsedto.AttachmentListResDTO;
import com.beiming.odr.referee.dto.responsedto.haoda.LawCaseAttachmentListResDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.transaction.annotation.Transactional;

/**
 * 文件 附件
 */
@Valid
public interface AttachmentApi {

  @Transactional(rollbackFor = Exception.class)
  DubboResult gdBatchSaveFile(@Valid GDBatchFilesReqDTO req);

  /**
   * 批量保存材料文件
   */
  DubboResult batchSaveFile(@Valid BatchFilesReqDTO batchFilesReqDTO);

  /**
   * 更新签章文书
   */
  DubboResult saveDocumentSign(@Valid DocumentSignReqDTO documentSignReqDTO);

  /**
   * 司法确认文书材料上传
   */
  DubboResult judicialFileUpload(@Valid BatchFilesReqDTO batchFilesReqDTO);

  /**
   * 司法确认文书材料删除
   */
  DubboResult judicialFileDelete(@Valid JudicialFileDeleteDTO batchFilesReqDTO);

  /**
   * 信访代理人授权委托书上传
   */
  DubboResult<Long> uploadAuthorizeProxy(AuthorizeProxyReqDTO reqDTO);

  /**
   * 获取信访代理人授权委托书
   */
  DubboResult<Boolean> getAuthorizeProxy(Long caseId, Long userId, Long personnelId);

  /**
   * 代理人授权委托书上传
   */
  DubboResult<Long> uploadAgentAuthorizeProxy(AgentAuthorizeProxyReqDTO reqDTO);

  /**
   * 获取代理人授权委托书
   */
  DubboResult<Boolean> getAgentAuthorizeProxy(Long caseId, Long personnelId, String agentType);

  /**
   * 用户发起质证
   */
  DubboResult applyEvidenceOppugn(EvidenceOppugnReqDTO evidenceOppugnReqDTO);

  DubboResult<AttachmentListResDTO> getEvidence(AttachmentReqDTO attachmentReqDTO);

  /**
   *
   */
  DubboResult<Boolean> updateTdhFileId(Long id, String tdhFileId);

  /**
   * 获取案件-诉讼文书材料
   * @param caseId
   * @return
   */
  DubboResult<ArrayList<LawCaseAttachmentListResDTO>> findAttachmentList(Long caseId);

  /**
   * 卷宗文书材料删除
   */
  DubboResult dossierFileDelete(@Valid DossierFileDeleteDTO dossierFileDeleteDTO);
}
