package com.beiming.odr.referee.dto.requestdto;

import com.beiming.framework.util.Java8DateUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;


@ApiModel(description = "同步案件进度")
@NoArgsConstructor
@Data
public class BatchSyncCaseProgressReqDTO implements Serializable {

  private static final long serialVersionUID = 7194656415927586690L;

  @ApiModelProperty(notes = "调解员id", example = "33", required = false)
  private Long mediatorId;

  @ApiModelProperty(notes = "调解员姓名", example = "调解员xx", required = false)
  private String mediatorName;

  @ApiModelProperty(notes = "案件id", example = "33", required = true)
  private Long caseId;

  @ApiModelProperty(notes = "content", example = "调解员发起...", required = true)
  @NotNull(message = "{progress.of.the.case.cannot.be.empty}")
  private String content;

  @DateTimeFormat(pattern = Java8DateUtils.DATE_TIME_FORMAT)
  private Date time;

}
