package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Data;

/**
 * 是否发送短信案件id list
 * 
 * @author qsh
 *
 * @2019年3月4日
 */
@Data
public class CaseImportListIdsReqDTO implements Serializable {
  private static final long serialVersionUID = 1L;


  @Valid
  @NotNull(message = "{case.id.cannot.be.empty}")
  @Size(message = "{case.id.cannot.be.empty}", min = 1)
  private List<Long> caseIds;

  /**
   * 选择性短信发送功能 0为发送，1为不发送
   */
  @NotNull(message = "{send.sms.off.null}")
  private Integer smsOff;

}
