package com.beiming.odr.referee.dto.requestdto;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotEmpty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

@Data
public class TagConfigDTO implements Serializable {

  /**
   * ID
   */
  private Long id;


  /**
   * 配置类型 已案定补案件标签CASE_SUBSIDY_TAG  风险研判RISK_JUDGMENT
   */
  @NotEmpty(message = "type can not be null")
  private String type;

  /**
   * 配置code CASE_SUBSIDY_TAG
   */
  @NotEmpty(message = "type code not be null")
  private String code;

  /**
   * 配置值
   */
  @NotEmpty(message = "value can not be null")
  private String value;


  /**
   * 备注
   */
  private String remark;


  /**
   * 状态 0启用 1删除
   */
  private Integer status;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;


  /**
   * 创建用户
   */
  private String createUser;

  /**
   * 是否可用 1可用 0禁用
   */
  private Integer enable;


}
