package com.beiming.odr.referee.dto.responsedto;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import java.io.Serializable;
import lombok.NoArgsConstructor;

/**
 * @Description 案件人|代理人数据变更记录
 * @Author blake
 * @Date 2019-07-28 21:43
 * @Version 1.0
 */
@Data
@ApiModel
@NoArgsConstructor
@AllArgsConstructor
public class TdhPersonnelAuditResDTO implements Serializable {

  private Long id; // 主键id

  private Long lawCaseId; // 案件id

  private Integer personnelType; // 案件人员类型 0:当事人 1代理人

  private String primaryId; // 唯一标识（身份证号码）

  private String modifyType; // 修改类型

  private String tdhUuid; // uuid

  private Integer differentPhone; // 手机是否修改

  private String paramJson; // 更新参数

  private Integer auditResult; // 审批结果

  private String auditPerson; // 审查人

  private String auditOpinion; // 审查意见

  private Integer status; // 数据状态：1无效，0正常

  private String remark; // 备注

  private String createUser; // 创建人

  private String updateUser; // 修改人

  private Integer version; // 版本

  private Long personnelId; //当事人时为personnel表id ，代理人时为agent_personnel表id
}
