package com.beiming.odr.referee.enums;

/**
 * Created by Jache on 2019/11/04 9:33.
 * 代理人辩护类型
 */
public enum DefenseTypeEnum {

  LAWYER("律师", "09_01010-1"),
  GUARDIAN("监护人", "09_01010-3"),
  PARTY_CLOSE_RELATIVES("当事人近亲属", "09_01010-4"),
  CITIZEN_SOCIAL_ORG("有关社会团体推荐的公民", "09_01010-5"),
  CITIZEN_PARTY_UNIT("当事人所在单位推荐的公民", "09_01010-6"),
  CITIZEN_PARTY_COMMUNITY("当事人所在社区推荐的公民", "09_01010-7"),
  GRASS_ROOTS_LEGAL_WORKERS("基层法律服务工作者", "09_01010-8"),







      ;

  private String name;
  private String tdhCode;


  DefenseTypeEnum(String name, String tdhCode) {
    this.name = name;
    this.tdhCode = tdhCode;
  }


  public String getName() {
    return name;
  }

  public String getTdhCode() {
    return tdhCode;
  }

  private static DefenseTypeEnum getEnumByTdhCode(String tdhCode) {
    DefenseTypeEnum[] values = values();
    for (DefenseTypeEnum defenseTypeEnum : values) {
      if (defenseTypeEnum.name().equals(tdhCode)) {
        return defenseTypeEnum;
      }
    }
    return null;
  }
}
