package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.MediationCaseBaseDTO;
import com.beiming.odr.referee.dto.requestdto.CancelCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.DeleteCasePersonnelReqDTO;
import com.beiming.odr.referee.dto.requestdto.EditCaseDisputeReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseAgentReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.OnlineFilingInfoReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseChatRoomResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseResDTO;
import com.beiming.odr.referee.dto.responsedto.OnlineFilingInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.SaveCaseUserResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;

/**
 * @Description: 调解案件api接口
 * @Author: caiwei
 * @Date: Created 2018-06-20
 */
@Valid
public interface MediationCaseApi {

  DubboResult<MediationCaseBaseDTO> getMediationCaseBaseInfoById(Long caseId);

  /**
   * 根据案件id查询案件信息
   */
  DubboResult<CaseResDTO> getMediationCaseInfoById(Long caseId);

  /**
   * 根据通达海id查询案件信息
   */
  DubboResult<MediationCaseBaseDTO> getMediationByCiteCaseId(String caseId);

  /**
   * 插入案件
   */
  DubboResult<Long> insertMediationCase(@Valid MediationCaseReqDTO mediationCaseReqDTO);

  /**
   * 编辑案件纠纷信息
   */
  DubboResult editCaseDisputeInfo(EditCaseDisputeReqDTO dto);

  /**
   * 新增或者修改案件代理人
   */
  DubboResult saveOrEditCaseAgent(MediationCaseAgentReqDTO reqDTO);

  /**
   * 新增或者修改案件人
   */
  DubboResult<SaveCaseUserResDTO> saveOrEditCaseUser(
      @Valid MediationCaseUserReqDTO mediationCaseUserReqDTO);

  /**
   * 删除案件人
   */
  DubboResult deleteCasePersonnel(@Valid DeleteCasePersonnelReqDTO reqDTO);

  /**
   * 删除代理人
   */
  DubboResult deleteCaseAgent(DeleteCasePersonnelReqDTO reqDTO);

  /**
   * 撤回调解
   */
  DubboResult<Integer> cancelLawCase(CancelCaseReqDTO reqDTO);

  /**
   * 获取调解案件材料
   */
  DubboResult getCaseMaterial(@Valid Long caseId);

  /**
   * 根据案件id查询案件基本信息
   */
  DubboResult<MediationCaseBaseDTO> getMediation(Long caseId);

  /**
   * 更新正式通达海流水号
   */
  DubboResult updateCaseCiteCaseFilingSeq(Long lawCaseId, String filingSeq);

  /**
   * 獲取立案信息
   */
  DubboResult<OnlineFilingInfoResDTO> getOnlineFilingInfo(OnlineFilingInfoReqDTO reqDTO);

  DubboResult<ArrayList<CaseChatRoomResDTO>> getChatRoomCaseList(Long userId);

  /**
   * 批量保存代理人数据
   */
  DubboResult batchSaveCaseAgentInfo(List<MediationCaseAgentReqDTO> mediationCaseAgentReqDTOs);
}
