package com.beiming.odr.referee.api;
/**
 *
 * @author ljf
 *
 */

import com.beiming.framework.domain.DubboResult;

public interface RefereeTaskApi {
//  No objection seven day confirm
  /**
   * 无异议调解方案机制--7天无异议默认为 达成调解协议
   * @return
   */
  DubboResult<Boolean> confirmBySevenDaysWithoutObjection();
  /**
   * 超期案件自动失败
   * @return
   */
  DubboResult<Boolean> overdueAutomaticFailure();

  /**
   * 失败立案异常处理
   * @return
   */
  DubboResult<Boolean> caseFailAutoFilingException();

  /**
   * 共道立案流水反馈
   * @return
   */
  DubboResult<Boolean> gdFilingSeqFeedback();

  /**
   * 批处理更新时间和状态
   *
   * @return
   */
  DubboResult<Boolean> updateMeetingEnd();

  /**
   * 案件监控调度队列存储短信
   *
   * @return
   */
  DubboResult<Boolean> caseMonitorMessage();

  /**
   * 案件监控调度获取队列可发送短信
   * @return
   */
  DubboResult<Boolean> caseMonitorQueueList();

  /**
   * 超72小时自动给案子分配调解员
   * @return
   */
  DubboResult<Boolean> caseAutoAssignMediator();

  DubboResult<Boolean> caseAutoDownLoadGDEvidence();


  /**
   * 同步案件评估状态
   * @return
   */
  DubboResult<Boolean> caseEvaluateSync();



  /**
   * 案件延期提醒
   * @return
   */
  DubboResult<Boolean> caseExtendMail();
}
