package com.beiming.odr.referee.api.haoda;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.haoda.ApplyDocumentDownloadReqDTO;
import com.beiming.odr.referee.dto.requestdto.haoda.ApplyForwardUrlRequestDTO;
import com.beiming.odr.referee.dto.requestdto.haoda.HaoDaFeedBackReqDTO;
import com.beiming.odr.referee.dto.requestdto.haoda.HaoDaTokenReqDTO;
import com.beiming.odr.referee.dto.responsedto.haoda.ApplyDocumentDownloadResDTO;
import com.beiming.odr.referee.dto.responsedto.haoda.CourtResDTO;
import com.beiming.odr.referee.dto.responsedto.haoda.ForwardUrlResDTO;
import com.beiming.odr.referee.dto.responsedto.haoda.HaoDaFeedBackResDTO;
import com.beiming.odr.referee.dto.responsedto.haoda.HaoDaTokenResDTO;
import java.util.ArrayList;
import java.util.Map;

/**
 * 昊达数据拉取api接口
 *
 * @author xiaoying
 * @date 2021/12/07
 */
public interface HaoDaPullApi {

  /**
   * 获取昊达授权Token
   *
   * @param reqDTO
   * @return
   */
  DubboResult<HaoDaTokenResDTO> getToken(HaoDaTokenReqDTO reqDTO);

  /**
   * 获取昊达-司法确认申请结果
   *
   * @param reqDTO
   * @return
   */
  DubboResult<HaoDaFeedBackResDTO> getJudicialConfirmResult(HaoDaFeedBackReqDTO reqDTO);

  /**
   * 司法确认申请文书材料下载
   *
   * @param reqDTO
   * @return
   */
  DubboResult<ApplyDocumentDownloadResDTO> applyDocumentDownload(
      ApplyDocumentDownloadReqDTO reqDTO);

  /**
   * 获取跳转url地址
   *
   * @param requestDTO
   * @return
   */
  DubboResult<ForwardUrlResDTO> getForwardUrl(ApplyForwardUrlRequestDTO requestDTO);

  /**
   * 获取昊达民事案由代码 -- 所有数据
   *
   * @return
   */
  DubboResult<ArrayList<Map<String, Object>>> getDisputeCodeList();

  /**
   * 获取昊达 法院数据列表
   *
   * @return
   */
  DubboResult<ArrayList<CourtResDTO>> getCourtList();
}