package com.beiming.odr.referee.dto;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import com.beiming.odr.referee.util.TimeStampToStrUtil;
import lombok.Setter;

/**
 * @Auther: 数字广东对接-在线法院实体类
 * @Date: 2019/2/1/001 14:18
 * @Description:
 */
@Setter
public class GDOnlineCourtDTO implements Serializable {

  private String type;
  private String status;
  private String startTime;
  private String endTime;
  private String actualStartTime;
  private String actualEndTime;
  private String caseSecurityId;
  private String caseCode;
  private String clerkName;
  private String trialOffline;
  private String scheduleSecurityId;
  private String roomName;
  private String judgeName;
  private String summonsUrl;
  private String statusName;
  private String decryptKey;

  public String getType() {
    return type;
  }

  public String getStatus() {
    return status;
  }

  public String getStartTime() {
    return TimeStampToStrUtil.timeStampToStr(startTime);
  }

  public String getEndTime() {
    return TimeStampToStrUtil.timeStampToStr(endTime);
  }

  public String getActualStartTime() {
    return TimeStampToStrUtil.timeStampToStr(actualStartTime);
  }

  public String getActualEndTime() {
    return TimeStampToStrUtil.timeStampToStr(actualEndTime);
  }

  public String getCaseSecurityId() {
    return caseSecurityId;
  }

  public String getCaseCode() {
    return caseCode;
  }

  public String getClerkName() {
    return clerkName;
  }

  public String getTrialOffline() {
    return trialOffline;
  }

  public String getScheduleSecurityId() {
    return scheduleSecurityId;
  }

  public String getRoomName() {
    return roomName;
  }

  public String getJudgeName() {
    return judgeName;
  }

  public String getSummonsUrl() {
    return summonsUrl;
  }

  public String getStatusName() {
    if (StringUtils.isNotBlank(this.getStatus())) {
      if ("plan".equalsIgnoreCase(this.getStatus())) {
        return "未庭审";
      } else if ("done".equalsIgnoreCase(this.getStatus())) {
        return "已庭审";
      } else if ("trialing".equalsIgnoreCase(this.getStatus())) {
        return "庭审中";
      }
    }
    return statusName;
  }

  public String getDecryptKey() {
    return decryptKey;
  }
}
