package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.enums.CategoryBigTypeEnum;
import com.beiming.odr.referee.enums.CategoryMiddleTypeEnum;
import com.beiming.odr.referee.enums.DocumentEvidenceTypeEnum;
import java.io.Serializable;
import lombok.Data;

/**
 * @Description: 案件材料请求参数实体
 * @Author: caiwei
 * @Date: Created 2018-06-28
 */
@Data
public class CaseMaterialReqDTO implements Serializable {

  private static final long serialVersionUID = -6117173900971855222L;

  /**
   * 文件名
   */
  private String fileName;

  /**
   * 文件fileid
   */
  private String fileId;

  /**
   * 附件大分类( 调解用，诉讼用，司法确认用等)
   */
  private CategoryBigTypeEnum categoryBig;

  /**
   * 附件中分类(书证、物证、等等)
   */
  private CategoryMiddleTypeEnum categoryMiddle;

  /**
   * 案件id
   */
  private Long lawCaseId;

  /**
   * 当类型为书证时,sign为详细小分类0默认附件 1调谐协议书;2 调解笔录;3调查笔录;4司法确认申请书;5调解申请书;6当事人权利义务告知书;7授权委托书;8调解协议履行证明;9调解回访记录;10结案表;
   */
  private DocumentEvidenceTypeEnum sign;

  /**
   * 会议Id
   */
  private Long meetingId;

  // 用户id
  private Long userId;

  // 创建者
  private String createUser;

  // 更新者
  private String updateUser;
}
