package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.enums.PushFollowStatusEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @Description
 * @Author Mr.Tang
 * @Date 18:00 2021/7/19
 */
@Data
public class CasePushFollowReqDTO implements Serializable {

  private static final long serialVersionUID = -916687769072142425L;

  /**
   * 案件id
   */
  @NotNull(message = "案件id不能为空")
  private Long lawCaseId;
  /**
   * 推送跟进状态
   */
  @NotNull(message = "推送跟进状态不能为空")
  private PushFollowStatusEnum pushFollowStatus;
  /**
   * 推送备注
   */
  private String pushComment;
  /**
   * 跟进机构id
   */
  @NotNull(message = "跟进机构id不能为空")
  private Long followOrgId;
  /**
   * 跟进调解员id
   */
  private Long followUserId;
  /**
   * 跟进登记时间：yyyy-MM-dd HH:mm:ss
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date followTime;
  /**
   * 跟进情况记录
   */
  private String followRecord;

}

