package com.beiming.odr.referee.dto.requestdto;

import com.beiming.framework.page.PageQuery;
import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import java.io.Serializable;
import lombok.Data;

/**
 * 卷宗查询请求
 * 
 * @author qsh
 * @data 2018年6月29日
 */
@Data
@EncryptDecryptData
public class DossierListReqDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = 1L;
  private String createUser; // 立卷人
  private String disputeType; // 纠纷类型
  @EncryptDecryptField
  private String caseNo; // 案件编号
  private String createStartTime;
  private String createEntTime;
  private Long orgId; // 机构id

}
