package com.beiming.odr.referee.dto.requestdto;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

@Data
public class LawCaseSubsidyStatReqDTO implements Serializable {


  /**
   * 纠纷类型
   */
  private String disputeType;


  /**
   * 开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date createTimeStart;


  /**
   * 结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date createTimeEnd;


  private List<Long> orgIds;
}
