package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.dto.DsrInfoDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @ProjectName: hainan-guoshang
 * @Package: com.beiming.odr.referee.dto.responsedto
 * @ClassName: ArbitrationListResponseDTO
 * @Author: lanqingyun
 * @Description:
 * @Date: 2024/5/16 17:44
 * @Version: 1.0
 */

@Data
@ApiModel(value = "仲裁案件返回参数")
public class ArbitrationResponseDTO implements Serializable {

  @ApiModelProperty(value = "案件id")
  private String ahdm;

  @ApiModelProperty(value = "案号")
  public String ah;

  @ApiModelProperty(value = "立案时间")
  private  String startTime;

  @ApiModelProperty(value = "结案时间")
  private String endTime;

  @ApiModelProperty(value = "收案时间")
  private String sarq;

  @ApiModelProperty(value = "案件来源")
  private String ajly;

  @ApiModelProperty(value = "收案编号")
  private String sabh;

  @ApiModelProperty(value = "案件类型代码")
  private String ajlxdm;

  @ApiModelProperty(value = "案件类型名称")
  private String ajlxmc;

  @ApiModelProperty(value = "案件名称")
  private String ajmc;

  @ApiModelProperty(value = "立案案由代码")
  private String laaydm;

  @ApiModelProperty(value = "立案案由名称")
  private String laaymc;

  @ApiModelProperty(value = "适用程序代码")
  private String sycxdm;

  @ApiModelProperty(value = "适用程序名称")
  private String sycxmc;

  @ApiModelProperty(value = "赔偿方式")
  private String compensationMethod;


  @ApiModelProperty(value = "赔偿事项")
  private String compensationMatters;


  @ApiModelProperty(value = "标的行为")
  private String subjectBehavior;


  @ApiModelProperty(value = "判决结果")
  private String judgmentResult;

  @ApiModelProperty(value = "法院代码")
  private String fydm;

  @ApiModelProperty(value = "法院名称")
  private String fymc;

  @ApiModelProperty(value = "案件状态代码")
  private String ajztdm;

  @ApiModelProperty(value = "案件状态名称")
  private String ajztmc;

  @ApiModelProperty(value = "书记员")
  private String sjymc;

  @ApiModelProperty(value = "法官")
  private String cbrmc;

  @ApiModelProperty(value = "法综账号")
  private String cbrdm;

  @ApiModelProperty(value = "当事人")
  private List<DsrInfoDTO> dsrList;

  private String lang;

  private String dsrString;

  @ApiModelProperty(value = "仲裁请求")
  private String  appeal;

  @ApiModelProperty(value = "收案人代码")
  private String  sardm;

  @ApiModelProperty(value = "收案人名称")
  private String  sarmc;

  @ApiModelProperty(value = "法定审限天数")
  private String fdsxts;

  @ApiModelProperty(value = "标的金额")
  private String targetAmount;
}
