package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.beiming.odr.referee.dto.MediationCaseAgentPersonnelDTO;
import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import com.beiming.odr.referee.dto.responsedto.document.AddressConfirmGetResDTO;
import com.beiming.odr.referee.enums.CardTypeEnum;
import com.beiming.odr.referee.enums.UserSexEnum;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/**
 * @Description: 协议相关人返回实体
 * @Author: caiwei
 * @Date: Created 2018-06-30
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EncryptDecryptData
public class CaseProtocolPersonnelResDTO implements Serializable {

  private static final long serialVersionUID = -4866238168967161027L;
  // 人员id
  private Long personnelId;

  // 案件id
  private Long lawCaseId;

  // 文书id
  private Long documentId;

  // 案件用户类型
  private String caseUserType;

  // 用来区分当事人和代理人标记---调解笔录里面使用
  private String agentName;

  /**
   * 人员序号
   */
  private Integer serialNumber;

  // 用户ID
  private Long userId;

  // 用户类型
  private String userType;

  // 名称
  private String userName;

  // 性别
  private String sex;

  // 电话
  @EncryptDecryptField
  private String phone;

  @EncryptDecryptField
  private String telephone;

  private String cardType;

  // 身份证号
  @EncryptDecryptField
  private String idCard;

  // 省份code
  private String provCode;

  // 城市code
  private String cityCode;

  // 区code
  private String areaCode;

  // 街道code
  private String streetCode;

  // 省份名称
  private String provName;

  // 城市名称
  private String cityName;

  // 区名称
  private String areaName;

  // 街道名称
  private String streetName;

  // 详细地址
  @EncryptDecryptField
  private String address;

  // 信用代码
  @EncryptDecryptField
  private String creditCode;

  // 法人代表
  private String corporation;


  /**
   * 电子邮箱
   */
  private String email;

  // 排序
  private Integer userOrder;

  private String nationality; //国籍

  private String nation; //民族

  @EncryptDecryptField
  private List<CaseProtocolAgentPersonnelResDTO> agentList;

  public CaseProtocolPersonnelResDTO(MediationCasePersonnelDTO personnel) {
    this.documentId = personnel.getDocumentId();
    this.caseUserType = personnel.getCaseUserType();
    this.userId = personnel.getUserId();
    this.userType = personnel.getUserType();
    this.userName = personnel.getName();
    this.sex = personnel.getSex();
    this.phone = personnel.getPhone();
    this.telephone = personnel.getTelephone();
    this.cardType = personnel.getCardType();
    this.idCard = personnel.getIdCard();
    this.provCode = personnel.getProvCode();
    this.cityCode = personnel.getCityCode();
    this.areaCode = personnel.getAreaCode();
    this.streetCode = personnel.getStreetCode();
    this.provName = personnel.getProvName();
    this.cityName = personnel.getCityName();
    this.areaName = personnel.getAreaName();
    this.streetName = personnel.getStreetName();
    this.address = personnel.getAddress();
    this.creditCode = personnel.getCreditCode();
    this.corporation = personnel.getCorporation();
    this.userOrder = personnel.getUserOrder();
    this.email = personnel.getEmail();
    this.nation = personnel.getNation();
    this.nationality = personnel.getNationality();
    List<MediationCaseAgentPersonnelDTO> agents = personnel.getAgentList();
    if (CollectionUtils.isEmpty(agents)) {
      this.agentList = Lists.newArrayList();
    } else {
      this.agentList = agents.stream().map(CaseProtocolAgentPersonnelResDTO::new).collect(Collectors.toList());
    }
  }

  public AddressConfirmGetResDTO convertAddressConfirmGetResDTO() {
    AddressConfirmGetResDTO resDTO = new AddressConfirmGetResDTO();
    resDTO.setDocumentId(this.documentId);
    resDTO.setPersonnelId(this.personnelId);
    resDTO.setCaseId(this.lawCaseId);
    resDTO.setUserId(this.getUserId());
    resDTO.setPhone(this.phone);
    resDTO.setAddress(this.address);
    resDTO.setEmail(this.email);
    resDTO.setOtherContact(this.telephone);
    resDTO.setCaseUserType(this.caseUserType);
    resDTO.setUserName(this.userName);
    return resDTO;
  }

  /**
   * 把当事人代理人组装成当事人信息 生成调解笔录时使用
   *
   * @param agent
   */
  public CaseProtocolPersonnelResDTO(CaseProtocolAgentPersonnelResDTO agent, Integer order, String agentTypeName) {
    this.setUserOrder(order);
    this.setAgentName(agentTypeName);
    this.setUserName(agent.getAgentName());
    this.setSex(UserSexEnum.valueOf(agent.getSex()).getName());
    if (StringUtils.isEmpty(agent.getCardType())) {
      this.setCardType("中华人民共和国居民身份证");
    } else {
      this.setCardType(CardTypeEnum.getCardTypeEnumByCode(agent.getCardType()).getName());
    }
    this.setIdCard(agent.getIdCard());
  }
}
