package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.enums.ContactStatusEnum;
import com.beiming.odr.referee.enums.ExamineStatusEnum;
import com.beiming.odr.referee.enums.FinancialSmsStatusEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * @author zhouxin
 * @since 2019/8/6
 */
@Data
@NoArgsConstructor
@ToString
public class LawCaseFinancialDTO implements Serializable {

  private static final long serialVersionUID = 1312426682900931291L;

  private Long id;

  /**
   * 案件id
   */
  private Long lawCaseId;

  /**
   * 交易号
   */
  private String transactionNumber;

  /**
   * 联系状态
   *
   * @see ContactStatusEnum
   */
  private Integer contactStatus;

  /**
   * 审核状态
   *
   * @see ExamineStatusEnum
   */
  private Integer examineResult;

  /**
   * 本金
   */
  private BigDecimal principal;

  /**
   * 利率（年）%
   */
  private BigDecimal interestRate;

  /**
   * 逾期利率（年）%
   */
  private BigDecimal overdueRate;

  /**
   * 平台服务费（年）%
   */
  private BigDecimal serviceRate;

  /**
   * 审核意见
   */
  private String examineView;

  /**
   * 审查人
   */
  private String examiner;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  private Date examineTime;

  private FinancialSmsStatusEnum smsStatus;

  private String batchNum;
}
