package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * 案件与用户关系
 *
 * @author qsh
 * @data 2018年7月10日
 */
@Data
@EncryptDecryptData
public class LawCasePersonResDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  private Long id;
  /**
   * 案件号
   */
  @EncryptDecryptField
  private String caseNum;

  /**
   * 案件id
   */
  private Long lawCaseId;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 个人信息
   * 真实姓名
   * 角色为机构或企业时， 法人或者机构代表人信息，存在个人信息中
   */
  private String userName;

  /**
   * 案件用户类型（0：申请人 1：被申请人）
   */
  private String caseUserType;

  /**
   * 用户类型（0：自然人 1：法人 2：非法人组织）
   */
  private String userType;

  /**
   * 联系电话
   */
  @EncryptDecryptField
  private String phone;

  /**
   * 证件类型
   */
  private String cardType;

  /**
   * 身份证号
   */
  @EncryptDecryptField
  private String idCard;

  /**
   * 当事人证件图片名称
   */
  private String cardImage;

  /**
   * 当事人证件图片地址
   */
  private String cardImageUrl;

  /**
   * 国籍
   */
  private String nationality;

  /**
   * 民族
   */
  private String nation;
  
  /** 国籍中文名称 */
  private String nationalityName;
  /** 民族中文名称 */
  private String nationName;
  /** 证件类型中文名称 */
  private String cardTypeName;

  /**
   * 变更状态
   */
  private String approvalStatus;

  private String sex;

  @EncryptDecryptField
  private List<LawCaseAgentPersonResDTO> agentList;

  @EncryptDecryptField
  private String address;

  /**
   * 法人姓名
   */
  private String legalPersonName;

  /**
   * 公司信用代码
   */
  @EncryptDecryptField
  private String creditCode;

  /**
   * 常驻地址
   */
  @EncryptDecryptField
  private String residentAddress;

  /**
   * 现住地址
   */
  @EncryptDecryptField
  private String currentAddress;

  /**
   * 常住地址
   */
  @EncryptDecryptField
  private String permanentAddress;

  /**
   * 户籍地址
   */
  @EncryptDecryptField
  private String residenceAddress;

  /**
   * 邮寄地址
   */
  @EncryptDecryptField
  private String mailingAddress;

}
