package com.beiming.odr.referee.dto.responsedto.haoda;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 网上立案和司法确认案件详情中用户信息：包括申请人和被申请人
 *
 * @author xiaoying
 * @date 2022/01/17
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CaseUserDetailDTO implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  /**
   * 案件用户类型 申请人和被申请人 applicant  申请人 respondent 被申请人
   */
  private String caseUserType;

  /**
   * 用户类型 自然人 法人 非盈利组织
   */
  private String userType;

  /**
   * 自然人 用户姓名 法人和非盈利组织的公司名称或机构名称
   */
  private String userName;

  /**
   * 法人和非盈利组织的 法定代表人姓名
   */
  private String legalPerson;

  /**
   * 企业和非盈利组织的信用代码（注册登记号） 自然人时为空
   */
  private String creditCode;

  /**
   * 用户性别
   */
  private String userSex;

  /**
   * 证件类型
   */
  private String cardType;

  /**
   * 证件类型名称
   */
  private String cardTypeName;

  /**
   * 证件号码
   */
  private String idCard;

  /**
   * 证件图片名称
   */
  private String cardImage;

  /**
   * 证件图片地址
   */
  private String cardImageUrl;

  /**
   * 联系电话
   */
  private String phone;

  /**
   * 司法确认和网上立案-详细地址
   */
  private String detailAddress;

  /**
   * 司法确认和网上立案-常驻地址
   */
  private String residentAddress;


  /**
   * 现住地址
   */
  private String currentAddress;

  /**
   * 常住地址
   */
  private String permanentAddress;

  /**
   * 户籍地址
   */
  private String residenceAddress;

  /**
   * 邮寄地址
   */
  private String mailingAddress;


  /**
   * 当事人的代理人
   */
  private List<CaseUserAgentDetailDTO> agentList;
}