package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.CasePushFollowReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseVisitListReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseVisitReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseVisitResDTO;
import java.util.ArrayList;

/**
 * @author caiyuanxin
 * @date 2021/05/11
 */
public interface CaseVisitApi {
  /**
   * 保存案件回访记录
   */
  DubboResult<Boolean> saveCaseVisit(CaseVisitReqDTO dto);

  /**
   * 查询案件回访记录
   */
  DubboResult<CaseVisitResDTO> getCaseVisitList(CaseVisitListReqDTO caseVisitReqDTO);

  /**
   * @Description 保存案件推送信息
   * @Author Mr.Tang
   * @Date 10:28 2021/7/20
   */
  DubboResult<Boolean> addCasePushFollow(CasePushFollowReqDTO dto);

  void addSecondCasePushFollow(Long caseId);

  DubboResult<ArrayList<CasePushFollowReqDTO>> getCasePushFollowList(Long caseId);

}
