package com.beiming.odr.referee.dto.requestdto;

import com.alibaba.fastjson.JSONObject;
import com.beiming.odr.referee.enums.CaseProgressEnum;
import com.beiming.odr.referee.enums.CaseStatusEnum;
import com.beiming.odr.referee.enums.NationEnum;
import com.beiming.odr.referee.enums.OdrCaseTypeEnum;
import com.beiming.odr.user.api.common.enums.MediationTypeEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Data;

@Data
public class IntranetCaseReqDTO implements Serializable {
  /**
   * id
   */
  private String id;

  /**
   * 案件编号
   */
  private String caseNo;

  /**
   * 纠纷发生日期
   */
  private Date happenTime;

  /**
   * 纠纷类型code
   */
  private String disputeTypeCode;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 纠纷主体
   */
  private String mainDispute;

  /**
   * 案件状态
   */
  private String lawCaseStatus;

  /**
   * 登记时间
   */
  private Date accessDate;


  /**
   * 所属调委会
   */
  private String accessDepartmentId;


  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 申请人诉求
   */
  private String appeal;

  /**
   * 纠纷描述
   */
  private String disputeContent;

  /**
   * 案件来源
   */
  private String origin;

  /**
   * 涉及总人数
   */
  private Integer peopleSum;

  /**
   * 是否跨界纠纷
   */
  private String isAcross;

  /**
   * 涉及人群
   */
  private String acceptObject;

  /**
   * 是否疑难复杂纠纷
   */
  private String isPuzzle;

  /**
   * 是否历史遗留积案
   */
  private String ifArchive;

  /**
   * 受理用户
   */
  private String mediatorId;

  /**
   * 受理用户部门（调解工作室编码）
   */
  private String orgId;

  /**
   * 接收案件时间 受理时间
   */
  private Date acceptTime;

  /**
   * 调解开始时间
   */
  private Date startTime;

  /**
   * 调解结束时间
   */
  private Date endTime;

  /**
   * 案件完成时间
   */
  private Date caseCompleteTime;

  /**
   * 创建用户
   */
  private String creatorId;

  /**
   * 创建用户
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createDate;

  /**
   * 调解地点
   */
  private String address;

  /**
   * 涉案金额
   */
  private String disputeAmount;

  /**
   * 当事人
   */
  private List<IntranetCasePersonnelReqDTO> personnelList;

  /**
   * 案件材料
   */
  List<IntranetAttachmentReqDTO> attachmentList;

  public MediationCaseReqDTO convertCaseReqDTO() {
    MediationCaseReqDTO reqDTO = new MediationCaseReqDTO();
    reqDTO.setMediationType(MediationTypeEnum.PEOPLE_MEDIATION.name());
    reqDTO.setCreatorId(null);
    reqDTO.setCreatorType(null);
    reqDTO.setCaseNo(this.caseNo);
    reqDTO.setLawCaseStatus(this.lawCaseStatus);
    reqDTO.setApprovalType(0);
    CaseProgressEnum caseProgress = CaseStatusEnum.getCaseProgressEnum(CaseStatusEnum.valueOf(this.lawCaseStatus));
    reqDTO.setCaseProgress(caseProgress.name());
    reqDTO.setDisputesId(null);
    reqDTO.setDisputeTypeCode(this.disputeTypeCode);
    reqDTO.setDisputeType(this.disputeType);
    reqDTO.setProvCode(null);
    reqDTO.setCityCode(null);
    reqDTO.setAreaCode(null);
    reqDTO.setStreetCode(null);
    reqDTO.setCommunityCode(null);
    reqDTO.setProvName(null);
    reqDTO.setCityName(null);
    reqDTO.setAreaName(null);
    reqDTO.setStreetName(null);
    reqDTO.setCommunityName(null);
    reqDTO.setAddress(this.address);
//        reqDTO.setOrgId();
//        reqDTO.setOrgName();
//        reqDTO.setOrgAreaCode();
//        reqDTO.setMediatorId();
//        reqDTO.setMediatorName();
    reqDTO.setStartTime(this.startTime);
    reqDTO.setEndTime(this.endTime);
    reqDTO.setOrigin(this.origin);
    reqDTO.setSmsOff(false);
    reqDTO.setAppeal(this.appeal);
    reqDTO.setDisputeContent(this.disputeContent);
    reqDTO.setCreateUser(this.createUser);
    reqDTO.setCaseType(OdrCaseTypeEnum.COMMON_CASE.getCode());
    reqDTO.setDisputeAmount(this.disputeAmount);
    reqDTO.setCreateTime(this.createDate);

    List<MediationCaseUserReqDTO> userReqDTOList = new ArrayList<>();
    for (IntranetCasePersonnelReqDTO personnel : this.personnelList) {
      MediationCaseUserReqDTO userReqDTO = new MediationCaseUserReqDTO();
      userReqDTO.setUserId(null);
      userReqDTO.setCaseUserType(personnel.getCaseUserType());
      userReqDTO.setUserType(personnel.getUserType());
      userReqDTO.setName(personnel.getUserName());
      userReqDTO.setSex(personnel.getSex());
      userReqDTO.setPhone(personnel.getPhone());
      userReqDTO.setTelephone(null);
      userReqDTO.setIdCard(personnel.getIdCard());
      userReqDTO.setCardType(personnel.getCardType());
      userReqDTO.setAddress(personnel.getAddress());
      userReqDTO.setCreditCode(personnel.getCreditCode());
      userReqDTO.setCorporation(personnel.getCorporation());
//            userReqDTO.setUserRegisterOrigin();
      userReqDTO.setCreateUser(personnel.getCreateUser());
      userReqDTO.setNation(personnel.getNation());
      NationEnum nation = NationEnum.getNationEnumByCode(personnel.getNation());
      userReqDTO.setNationName(nation == null ? null : nation.getName());
      userReqDTOList.add(userReqDTO);
    }
    reqDTO.setPersonnelList(userReqDTOList);
    return reqDTO;
  }


  public String convertIdParamStr() {
    JSONObject json = new JSONObject();
    json.put("id", this.id);
    json.put("caseNo", this.caseNo);
    return json.toJSONString();
  }
}