package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import com.beiming.odr.referee.enums.UserRoleEnum;
import lombok.Data;

/**
 * 转移调解机构请求类
 * 
 * @author qsh
 * @data 2018年7月4日
 */
@Data
public class TransferMediationReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  @NotNull(message = "{case.id.cannot.be.empty}")
  private Long caseId;
  @NotNull(message = "{organization.id.cannot.be.empty}")
  private Long orgId;
  @NotBlank(message = "{transfer.out.reason.cannot.be.empty}")
  private String detailRason;
  private Long userId;
  private String userName;
  private List<UserRoleEnum> roleTypes;
  //转移类型。
  private String transferType;
}
