package com.beiming.odr.referee.dto.requestdto.haoda;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 申请-当事人
 *
 * @author xiaoying
 * @date 2021/12/10
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ApplyParty implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  /**
   * 1 自然人
   * 3 非法人其他组织
   * 2 法人
   */
  @ApiModelProperty(notes = "当事人类型", example = "666")
  private Integer type;

  /**
   * 20 申请人
   * 30 被申请人
   */
  @ApiModelProperty(notes = "当事人诉讼地位", example = "666")
  private Integer locusStandi;

  @ApiModelProperty(notes = "当事人姓名", example = "666")
  private String name;

  /**
   * 0 未知的性别
   * 1 男
   * 2 女
   */
  @ApiModelProperty(notes = "当事人性别（当事人类型为自然人时必填）", example = "666")
  private Integer sex;

  @ApiModelProperty(notes = "手机号码（当事人为原告自然人必填）", example = "666")
  private String phone;

  /**
   * 1 居民身份证
   * 2 中国公民护照
   * 3 台湾居民来往大陆通行证
   * 4 港澳居民来往内地通行证
   * 5 外国公民护照
   * 6 户口薄
   * 7 社会统一信用代码证
   * 8 律师执业证
   * 9 机动车驾驶证
   * 10 军警证件
   * 255 其他证件
   */
  @ApiModelProperty(notes = "证件类型(当事人为原告自然人必填)", example = "666")
  private Integer idCardType;

  @ApiModelProperty(notes = "证件号码（当事人为原告自然人必填）", example = "666")
  private String idCard;

  /**
   * 当事人证件材料
   */
  private List<ApplyDocument> documentList;

  @ApiModelProperty(notes = "现住地址", example = "666")
  private String address;

  @ApiModelProperty(notes = "常住地址（当事人为原告自然人必填）", example = "666")
  private String permanentAddress;

  @ApiModelProperty(notes = "户籍地址（当事人为原告自然人必填）", example = "666")
  private String domicileAddress;

  @ApiModelProperty(notes = "送达地址（当事人为原告自然人必填）", example = "666")
  private String mailAddress;

  @ApiModelProperty(notes = "法人代表名称（当事人为法人、非法人其它组织必填）", example = "666")
  private String legalPersonName;

  /**
   * 信用代码
   */
  private String creditCode;

  @ApiModelProperty(notes = "当事人的代理人列表（最多支持两个）", example = "666")
  private List<ApplyPartyAgent> applyPartyAgentList;


}