package com.beiming.odr.referee.dto.requestdto.haoda;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 获得昊达司法确认结果请求DTO
 * @author xiaoying
 * @date 2021/12/07
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class HaoDaFeedBackReqDTO implements Serializable {

  private static final long serialVersionUID = -3209068441805383190L;

  /**
   * 案件Id
   */
  @NotNull(message = "{案件Id不能为空}")
  private String caseId;

  /**
   * 用户Id
   */
  private String userId;

  /**
   * 授权token
   */
  private String token;

  /**
   * 1 网上立案  2 司法确认
   */
  private String type;

}