package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import java.util.TreeSet;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
public class SubsidyStatRespDTO implements Serializable {

  /**
   * 区域时间通过数量统计
   */
  private AuditAreaTimeDTO auditAreaTime;


  /**
   * 案由分布统计
   */
  private List<NameCountDTO> disputeTypeCount;

  /**
   * 涉案金额统计
   */
  private List<NameCountDTO> caseAmountCount;

  /**
   * 案件标签统计
   */
  private List<NameCountDTO> caseTagCount;


  @Data
  @NoArgsConstructor
  public static class AuditAreaTimeDTO implements Serializable {


    /**
     * 统计的日期标题
     */
    private TreeSet<String> date;


    /**
     * 区域列表
     */
    private List<AreaNameCountsDTO> areaCounts;

  }

  @Data
  @NoArgsConstructor
  public static class AreaNameCountsDTO implements Serializable {

    /**
     * 区域名称
     */
    private String areaName;


    /**
     * 数据
     */
    private List<Long> counts;

  }

  @Data
  @NoArgsConstructor
  public static class NameCountDTO implements Serializable {

    /**
     * 统计类型
     */
    private String name;

    /**
     * 数量
     */
    private Long count;

  }

}
