package com.beiming.odr.referee.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @ProjectName: hainan-guoshang
 * @Package: com.beiming.odr.referee.dto
 * @ClassName: litigationCaseProgressDTO
 * @Author: lanqingyun
 * @Description:
 * @Date: 2024/5/14 17:07
 * @Version: 1.0
 */

@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class LitigationCaseProgress implements Serializable {

  private Long id;

  @ApiModelProperty(value = "案件id")
  private String ahdm;

  @ApiModelProperty(value = "案件进度")
  private String progressContent;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @ApiModelProperty(value = "创建时间")
  private Date startTime;

}
