package com.beiming.odr.referee.dto;

import com.beiming.framework.page.PageQuery;
import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import java.io.Serializable;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 查询调解列表的请求参数(Mapper使用)
 *
 * @author DJQ 2018年7月12日
 */
@Data
@EqualsAndHashCode(callSuper = false)
@EncryptDecryptData
public class MediationListDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = -2326143176608490189L;

  private String roleType; // 用户角色类型： 纠纷登记员 调解人 普通人
  private Long userId; // 用户ID
  private String userType; // 用户类型（申请人，被申请人，调解人）
  private Long orgId; // 服务机构编号

  private String disputeTypeCode; // 纠纷类型
  @EncryptDecryptField
  private String disputeNo; // 纠纷编号
  private Integer approvalType; // 审批类型：1=延期；2=纠纷信息；3=延期及纠纷
  private String provCode; // 省份code
  private String cityCode; // 城市code
  private String areaCode; // 区code
  private String streetCode; // 街道code
  private List<String> keyWord; // 关键词 编号、姓名、案号
  private List<String> nameQuery;
  private String startTime;
  private String endTime;
  private String mediationType; // 调解类型
  private Long queryOrgId; //根据机构id筛选
  private String transfer; // 是否转移
  private String retract; // 包含撤回
  private List<String> caseStatus; // 案件状态
  private String caseUserTypes; // 案件用户角色(多状态，逗号分隔)
  private String partyName; //当事人姓名
  private Integer actionType; //全部0，批量分配1，批量转移2
  private String origin;
  private Boolean orgConfirm; //机构业务负责人是否已经确认的字段
  private String caseProgress; //BEGIN; WAIT_ASSGIN 供查询
  private String followName;
  @EncryptDecryptField
  private String followphone;
  private Integer draft; // 草稿类型。
  private List<String> areaCodePrefixList; //地区编码前缀，查某地区及所有下级地区
  private List<Long> orgIds; //根据多个机构id筛选
  private Integer visit; // 0-需回访，1-无需回访

  /**
   * 调解员名称
   */
  private String mediatorName;

  /**
   * 根据案件状态来区分 网上立案和司法确认数据列表
   */
  private String lawStatus;

  /**
   * dbLink链接地址
   */
  private String dbLinkAddress;

  /**
   * 数据状态 0有效 1无效
   */
  private Integer status;

  /**
   * 根据组织机构id组进行查询 in查询通用
   */
  private String queryOrgIds;

  /**
   * 查询案件的ID集合
   */
  private List<Long> lawCaseIds;

  /**
   * 是否简易案件 1是0否
   */
  private Integer simple;

  private String manageCode;

  private Integer areaLevel;
}
