package com.beiming.odr.referee.dto.requestdto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description: 删除案件人实体类
 * @Author: caiwei
 * @Date: Created 2018-08-01
 */
@Data
public class DeleteCasePersonnelReqDTO implements Serializable {

  private static final long serialVersionUID = -7952267309437445596L;
  // 案件id
  @NotNull(message = "{case.id.cannot.be.empty}")
  private Long caseId;

  // 人员id
  @NotNull(message = "{personnel.id.cannot.be.empty}")
  private Long personnelId;

  // 用户id
  @NotNull(message = "{user.id.cannot.be.empty}")
  private Long userId;

  @NotBlank(message = "{idcard.cannot.be.empty}")
  private String idCard;
}
