package com.beiming.odr.referee.dto.requestdto.haoda;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 跳转地址请求DTO
 * @author xiaoying
 * @date 2021/11/25
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ApplyForwardUrlRequestDTO implements Serializable  {

  private static final long serialVersionUID = -7719004967037558229L;

  @ApiModelProperty(notes = "token", example = "张三")
  private String token;

  @ApiModelProperty(notes = "自然人用户姓名", example = "张三")
  private String userName;

  @ApiModelProperty(notes = "自然人用户性别", example = "1")
  private String userSex;

  @ApiModelProperty(notes = "自然人用户证件类型", example = "1")
  private String userIdCardType;

  @ApiModelProperty(notes = "自然人用户证件号码", example = "1")
  private String userIdCard;

  @ApiModelProperty(notes = "自然人用户手机号码", example = "1")
  private String userPhone;

  @ApiModelProperty(notes = "自然人用户类型", example = "1")
  private String userType;

  @ApiModelProperty(notes = "律师所在律所名称", example = "1")
  private String userLawFirm;

  @ApiModelProperty(notes = "律师执业证号", example = "1")
  private String userLicenseOfLawyer;

  @ApiModelProperty(notes = "申请案件id", example = "666")
  private String applyCaseId;

  @ApiModelProperty(notes = "申请类型", example = "1")
  private String applyType;

  @ApiModelProperty(notes = "申请人id", example = "张三")
  private String applyUserId;

  @ApiModelProperty(notes = "申请人手机号码", example = "13888888888")
  private String applyUserPhone;

  @ApiModelProperty(notes = "申请人性别", example = "1 男 2 女")
  private Integer applyUserSex;

  @ApiModelProperty(notes = "加密key", example = "昊达提供")
  private String encryptKey;
}