package com.beiming.odr.referee.enums;

/**
 * @Auther: Administrator
 * @Date: 2019/3/14/014 16:25
 * @Description:
 */
public enum ApprovalStatusEnum {
  NORMAL(0, "普通"), NEW(1, "新增"), UPDATE(2, "修改"), DELETE(3, "删除");
  private Integer code;
  private String name;

  ApprovalStatusEnum(int code, String name) {
    this.code = code;
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static ApprovalStatusEnum getInstanceByCode(Integer code) {
    ApprovalStatusEnum[] values = values();
    for (ApprovalStatusEnum approvalStatus : values) {
      if (approvalStatus.getCode().equals(code)) {
        return approvalStatus;
      }
    }
    return NORMAL;
  }

  public Integer getCode() {
    return code;
  }

  public void setCode(int code) {
    this.code = code;
  }
}
