package com.beiming.odr.referee.helper;

import com.beiming.odr.referee.enums.CaseProgressEnum;
import com.beiming.odr.referee.enums.CaseStatusEnum;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;

/**
 * @Description 撤诉操作辅助工具类
 * @Author blake
 * @Date 2020/4/17 4:29 下午
 * @Version 1.0
 */
public class WithdrawOperationHelper {

  /**
   * 判断当前案件是否允许申请撤诉
   */
  public static boolean setIsAllowWithdrawal(String personType,
      String lawCaseStatusFullCode, boolean isCaseBelongToMediator) {
    boolean isAllowWithdrawal = false;
    if (PersonTypeEnum.COMMON.name().equals(personType)) {
      if (lawCaseStatusFullCode.contains(CaseProgressEnum.START.name())
          || lawCaseStatusFullCode.contains(CaseProgressEnum.WAIT.name())
          || lawCaseStatusFullCode.equals(CaseStatusEnum.SUCCESS_MEDIATION.name())) {
        isAllowWithdrawal = true;
      }
    }
    if (PersonTypeEnum.STAFF.name().equals(personType) && isCaseBelongToMediator) {
      if (CaseStatusEnum.SUCCESS_MEDIATION.name().equals(lawCaseStatusFullCode)) {
        isAllowWithdrawal = true;
      }
    }
    return isAllowWithdrawal;
  }

}
