package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.DisputeStatisticsReqDTO;
import com.beiming.odr.referee.dto.requestdto.DisputeSubjectStatisticsReqDTO;
import com.beiming.odr.referee.dto.responsedto.DisputeTypeResDTO;
import com.beiming.odr.referee.dto.responsedto.DisputesSubjectStatisticsResDTO;
import com.beiming.odr.referee.dto.responsedto.StatisticsAreaCaseCountResDTO;
import java.util.List;

/**
 * @Author: chenjt
 * @Description: 报表统计
 * @Date: Created 2018-07-04 20:02
 */
public interface SubjectDisputeStatisticsApi {

  /**
   * 纠纷专题统计-调解案件走势分析-街道调解案件数量分析-调解状态分析-申请人角色分析-调解结果分析
   * @param reqDTO
   * @return
   */
  DubboResult<DisputesSubjectStatisticsResDTO> disputesSubjectStatistics(DisputeStatisticsReqDTO reqDTO);

  /**
   * 调解状态分析
   */
  List<StatisticsAreaCaseCountResDTO> statisticsAreaCaseStatus(DisputeStatisticsReqDTO reqDTO);

  /**
   * 纠纷类型排行
   */
  List<DisputeTypeResDTO> topDisputeTypeRank(DisputeSubjectStatisticsReqDTO reqDTO);

  /**
   * 调解状态分析-申请人角色分析-调解结果分析
   * @param reqDTO
   * @return
   */
  DubboResult<DisputesSubjectStatisticsResDTO> caseParameterTrendAnalysis(DisputeStatisticsReqDTO reqDTO);


  /**
   * 地图各区域纠纷数据
   * @param reqDTO
   * @return
   */
//  DubboResult<ArrayList<StatisticsAreaCaseCountResDTO>> disputeStatisticsData(DisputeStatisticsReqDTO reqDTO);

}
