package com.beiming.odr.referee.dto;

import com.beiming.odr.referee.constant.LocaleConst;
import lombok.Data;
import org.springframework.context.i18n.LocaleContextHolder;

/**
 * @author zhouxin
 * @since 2019/11/12
 */
@Data
public class LocaleDTO {

  public static final LocaleDTO DEFAULT = new LocaleDTO();

  private String value = "";

  private String twValue = "";

  private String usValue = "";

  public String localeValue() {
    switch (LocaleContextHolder.getLocale().toString().toLowerCase()) {
      case LocaleConst.EN:
        return usValue;
      case LocaleConst.TW:
        return twValue;
      default:
        return value;
    }
  }

  public LocaleDTO replace(CharSequence target, CharSequence replacement) {
    this.value = value.replace(target, replacement);
    this.twValue = twValue.replace(target, replacement);
    this.usValue = usValue.replace(target, replacement);
    return this;
  }

  public LocaleDTO replaceByLocale(CharSequence target, CharSequence cn, CharSequence tw, CharSequence en) {
    this.value = value.replace(target, cn);
    this.twValue = twValue.replace(target, tw);
    this.usValue = usValue.replace(target, en == null ? cn : en);
    return this;
  }
}