package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.consultancy.enums.DisputeTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @ProjectName: hainan-guoshang
 * @Package: com.beiming.odr.mastiff.domain.dto
 * @ClassName: RecommendSolution
 * @Author: lanqingyun
 * @Description:
 * @Date: 2024/4/3 16:28
 * @Version: 1.0
 */

@Data
@ApiModel(description = "推荐方案请求参数")
public class RecommendSolutionRequestDTO implements Serializable  {

  @ApiModelProperty(notes = "纠纷类型code", required = true, example = "NETWORK_COPYRIGHT_NEIGHBORINGRIGHT")
  @NotNull(message = "{type.of.dispute.cannot.be.empty}")
  private DisputeTypeEnum disputeTypeCode;

}
