package com.beiming.odr.referee.dto.requestdto.document;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class GDNoticeDocumentRequestDTO implements Serializable {

  private static final long serialVersionUID = -1600955385114760116L;

  @ApiModelProperty(notes = "案件ID密文形式", required = true)
  @NotBlank(message = "{gdao.participation.security.case.id.can.not.be.blank}")
  private String securityCaseId;

  @ApiModelProperty(notes = "自然人姓名或公司名称")
  @NotBlank(message = "gdao.participation.entity.name.can.not.be.blank")
  private String entityName;

  @ApiModelProperty(notes = "身份证号或社会统一信用代码")
  @NotBlank(message = "gdao.participation.card.num.can.not.be.blank")
  private String cardNo;

}
