package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Auther: JACHE
 * @Date: 2019/6/3/003 15:50
 * @Description: 代理人實體
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@EncryptDecryptData
public class LawCaseAgentPersonResDTO implements Serializable {

  private static final long serialVersionUID = -7563385091999158865L;
  private Long id;

  private String citeAgentId; //引调代理人id

  private String agentName; //代理人姓名

  private Long lawCaseId; //案件id

  private Long userId; //用户id

  private String litigantId; //当事人id

  private String litigantPersonId; //当事人用户表id

  private String litigantCaseUserType; //案件用户类型（申请人 ,被申请人）

  private String litigantName; //当事人名称

  private String sex; //性别

  private String nation; //民族

  private String nationality; //国籍
  
  /** 国籍中文名称 */
  private String nationalityName;
  /** 民族中文名称 */
  private String nationName;
  /** 证件类型中文名称 */
  private String cardTypeName;

  @EncryptDecryptField
  private String lawyerCardNum; //律师证件号

  @EncryptDecryptField
  private String phone; //联系电话

  @EncryptDecryptField
  private String idCard;  //身份证号码

  private String cardType;  //证件类型

  private Integer userOrder; //排序

  private String userRegisterOrigin; //用户注册来源

  private String approvalStatus; //通达海审批状态

  private String agentType; //代理人类型

  @EncryptDecryptField
  private String telephone; //固定电话

  private String email; //邮件地址

  @EncryptDecryptField
  private String address;
}
