package com.beiming.odr.referee.dto.responsedto.calc;

import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

@Data
public class InfringementResDTO implements Serializable {

  private static final long serialVersionUID = -5961679341603940285L;
  // 赔偿金额
  private BigDecimal allowance;
  // 被扶养人生活费
  private BigDecimal alimony;
  // 被扶养人生活费
  private String alimonyDesc;
  // 未成年
  private BigDecimal youngFee;
  // 无能力
  private BigDecimal inabilityFee;
  // 被扶养人60周岁--74周岁
  private BigDecimal oldFeeOne;
  // 被扶养人大于74周岁
  private BigDecimal oldFeeTwo;
  // 医疗费
  private BigDecimal medicalExpenses;
  // 误工费
  private BigDecimal lossWorkingTime;
  // 误工费描述
  private String lossWorkingTimeDesc;
  // 护理费
  private BigDecimal nursingExpenses;
  // 护理费描述
  private String nursingExpensesDesc;
  // 交通费
  private BigDecimal trafficExpense;
  // 住院伙食补助费
  private BigDecimal hospitalizedFoodAllowance;
  // 住院伙食补助费 描述
  private String  hospitalizedFoodAllowanceDesc;
  // 营养费
  private BigDecimal nutritionExpenses;
  // 残疾赔偿金
  private BigDecimal disabilityCompensation;
  // 残疾辅助器皿费
  private BigDecimal auxiliaryVesselFee;
  // 丧葬费
  private BigDecimal funeralExpenses;
  // 丧葬费描述
  private String funeralExpensesDesc;
  // 死亡赔偿金
  private BigDecimal deathCompensation;
  // 死亡或残疾赔偿金描述
  private String compensationDesc;
  // 精神损害赔偿金
  private BigDecimal compensationMentalDamages;

  public InfringementResDTO() {
    this.allowance = BigDecimal.ZERO;
    this.youngFee = BigDecimal.ZERO;
    this.inabilityFee = BigDecimal.ZERO;
    this.oldFeeOne = BigDecimal.ZERO;
    this.oldFeeTwo = BigDecimal.ZERO;
  }
}
