package com.beiming.odr.referee.dto.responsedto.calc;

import java.io.Serializable;
import java.math.BigDecimal;

import lombok.Data;

/*
 * 工伤赔偿返回实体类
 */
@Data
public class WorkCompensationResDTO implements Serializable {

  private static final long serialVersionUID = -2232467848933198619L;
  // 一次性伤残补助金   --- 列入总额计算
  private BigDecimal disabledAllowance;
  // 伤残津贴
  private BigDecimal invalidityAllowance;
  // 一次性工伤医疗补助金
  private BigDecimal workMedicalAllowance;
  // 一次性伤残就业补助金
  private BigDecimal disabledEmploymentAllowance;
  // 停工留薪期工资
  private BigDecimal downtimeSalary;
  // 停工留薪期护理费
  private BigDecimal downtimeNursingFree;
  // 评残后护理费
  private BigDecimal disabilityFree;
  // 其他费用
  private BigDecimal otherAllowance;
  //  文件中标黄汇总
  private BigDecimal allFee;
  // 住院伙食补助费
  private BigDecimal hospitalizedFoodAllowance;
  // 医疗费
  private BigDecimal medicalExpenses;
  // 食宿费
  private BigDecimal boardAndLodging;
  // 工伤康复费
  private BigDecimal injuryRecoveryFee;
  // 辅助器皿费
  private BigDecimal auxiliaryVesselFee;
  // 安家补助费
  private BigDecimal subsidySettlingDown;
  // 交通费
  private BigDecimal trafficExpense;
  // 本人工资（统筹地区平均工资的0.6~3）
  private BigDecimal salary;
  // 职工平均工资
  private BigDecimal employeesAvgSalary;
  private BigDecimal foodStandard;


}
