package com.beiming.odr.referee.enums;

/**
 * 进度内容枚举
 * 
 * @author qsh
 * @data 2018年7月6日
 */
public enum ProgressContextEnum {

  /**
   * 卷宗失败
   */
  DOSSIER_FAIL("案件编号为#caseNo#的#caseType#电子卷宗审核人#name#已设置为审核失败，失败原因：#failReason#。"),

  /**
   * 卷宗归档
   */
  DOSSIER_PIGEONHOLE("立卷人#name#已归档案件编号为#caseNo#的#caseType#电子卷宗。"),
  /**
   * 案件超期未处理完成,自动设置为调解失败。
   */
  OVERDUECASE60DAYS_FAIL("案件超期未处理完成,自动设置为调解失败。"),
  /**
   * 卷宗审核通过
   */
  DOSSIER_PASS("审核人#name#审核通过案件编号为#caseNo#的#caseType#电子卷宗。"),

  /**
   * 案件导入进度枚举
   */
  CASE_IMPORT_SUCESS("纠纷导入成功");

  private String name;

  public String getName() {
    return name;
  }

  /**
   * @param name
   */
  private ProgressContextEnum(String name) {
    this.name = name;
  }

}
