/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.referee.util.sm4util;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.beiming.odr.referee.util.sm4util.SM4Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class EncryptDecryptUtil {
    public static <T> T encrypt(Field[] declaredFields, T paramsObject) throws IllegalAccessException {
        for (Field field : declaredFields) {
            EncryptDecryptField sensitiveField = field.getAnnotation(EncryptDecryptField.class);
            if (Objects.isNull(sensitiveField)) continue;
            field.setAccessible(true);
            Object object = field.get(paramsObject);
            if (!(object instanceof String)) continue;
            String value = (String)object;
            if (StringUtils.isNotEmpty((CharSequence)value) && !EncryptDecryptUtil.checkIsEncrypt(value).booleanValue()) {
                field.set(paramsObject, "xy_db_encrypt_" + SM4Utils.encryptDataCbc(value));
                continue;
            }
            field.set(paramsObject, value);
        }
        return paramsObject;
    }

    public static <T> T decrypt(T result) throws IllegalAccessException {
        Field[] declaredFields;
        Class<?> resultClass = result.getClass();
        for (Field field : declaredFields = resultClass.getDeclaredFields()) {
            ArrayList resultList;
            EncryptDecryptField sensitiveField = field.getAnnotation(EncryptDecryptField.class);
            if (Objects.isNull(sensitiveField)) continue;
            field.setAccessible(true);
            Object object = field.get(result);
            if (object instanceof String) {
                String value = (String)object;
                if (StringUtils.isNotEmpty((CharSequence)value) && EncryptDecryptUtil.checkIsEncrypt(value).booleanValue()) {
                    field.set(result, SM4Utils.decryptDataCbc(value.substring(14, value.length())));
                    continue;
                }
                field.set(result, value);
                continue;
            }
            if (!(object instanceof List) && !(object instanceof ArrayList) || (resultList = (ArrayList)object).size() <= 0 || !EncryptDecryptUtil.needToDecrypt(resultList.get(0))) continue;
            for (Object childResult : resultList) {
                EncryptDecryptUtil.decrypt(childResult);
            }
        }
        return result;
    }

    private static boolean needToDecrypt(Object object) {
        Class<?> objectClass = object.getClass();
        EncryptDecryptData sensitiveData = (EncryptDecryptData)AnnotationUtils.findAnnotation(objectClass, EncryptDecryptData.class);
        return Objects.nonNull(sensitiveData);
    }

    private static Boolean checkIsEncrypt(String source) {
        return source.contains("xy_db_encrypt_");
    }
}

