package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import com.beiming.odr.referee.dto.requestdto.AttachmentListReqDTO;
import com.beiming.odr.referee.dto.requestdto.CasePersonReqDTO;
import com.beiming.odr.referee.dto.requestdto.CasePersonnelReqDTO;
import com.beiming.odr.referee.dto.requestdto.DelFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawCasePersonnelReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.OperatorReqDTO;
import com.beiming.odr.referee.dto.requestdto.UpdatePartyDataReqDTO;
import com.beiming.odr.referee.dto.requestdto.UserIdListReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseProtocolPersonnelResDTO;
import com.beiming.odr.referee.dto.responsedto.LawCasePersonResDTO;
import com.beiming.odr.referee.dto.responsedto.LawCaseResponseDTO;
import com.beiming.odr.referee.dto.responsedto.NotReadNumResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * 案件人员api
 *
 * @author xzy
 * @data 2018年9月25日
 */
@Valid
public interface LawCasePersonnelApi {

  /**
   * 通过案件id查询案件人员
   *
   * @param caseId
   * @return
   */
  DubboResult<ArrayList<CaseProtocolPersonnelResDTO>> getPersonList(@Valid @NotNull(
      message = "{common.parameter.is.null}") Long caseId);

  /**
   * 判断当前用户是否有上传调解材料的权限
   * @param userId 用户id
   * @param caseId 案件id
   *
   */
  DubboResult checkUpload(@Valid
      @NotNull(message = "{user.id.cannot.be.empty}") Long userId,
      @Valid @NotNull(message = "{case.id.cannot.be.empty}") Long caseId);

  /**
   * 判断当前用户是否有删除调解材料的权限
   * @param delFileReqDto
   *
   */
  DubboResult checkDel(@Valid DelFileReqDTO delFileReqDto);


  /**
   * 判断当前用户是否有下载调解材料的权限
   * @param attachmentListReqDto
   */
  DubboResult checkDownload(@Valid AttachmentListReqDTO attachmentListReqDto);

  DubboResult updatePartyData(UpdatePartyDataReqDTO reqDto);

  /**
   * 获取人员名称id对应列表
   */
  DubboResult<ArrayList<NotReadNumResDTO>> getCasePersonNameList(Long lawCaseId);

  void updateLawCasePersonnelWithNewOpt(Long caseId, Long personnelId, Boolean isAgree);

  void updateLawCasePersonnelWithModifyOpt(LawCasePersonnelReqDTO lawCasePersonnelReqDto);

  void updateLawCasePersonnelWithDelOpt(Long lawCaseId, Long personnelId, Boolean isAgree);

  LawCaseResponseDTO selectNormal(Long lawCaseId);

  void updateParty(LawCasePersonnelReqDTO lawCasePersonnel);

  void sendCommonYtCase(String phone, String userName, LawCaseReqDTO lawCase, long l);

  void updateLawCasePersonnelWithModifyOpt(Long id);

  List<String> selectNameByPhone(String phone);

  /**
   * 邀请协助调解员
   * @param reqDTO 邀请人员列表
   * @param operator 操作人
   */
  DubboResult inviteMediatorHelp(@Valid UserIdListReqDTO reqDTO, OperatorReqDTO operator);


  /**
   * 通过案件id查询案件人员
   *
   * @param dto
   * @return
   */
  DubboResult<ArrayList<MediationCasePersonnelDTO>> getPersonList(@Valid CasePersonReqDTO dto);

  List<LawCasePersonResDTO> selectPersonnelList(Long lawCaseId);

  List<LawCasePersonResDTO> selectPersonnelListByUserIds(Long currentCaseId, List<Long> senderIds);

  /**
   * 根据CasePersonnelReqDTO条件查询案件相关人员信息
   * @param dto
   * @return
   */
  DubboResult<ArrayList<LawCasePersonResDTO>> getCasePersonList(CasePersonnelReqDTO dto);

  /**
   * 更新 law_case_personnel表中当事人对应的证件图片
   * @param lawCasePersonnelId
   */
  DubboResult updateCasePersonCardImage(Long lawCasePersonnelId, String cardImage, String fileName);
}
