package com.beiming.odr.referee.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class MediationCasePersonnelBriefDTO implements Serializable {

  private static final long serialVersionUID = 5946545033240232723L;

  /**
   * 用户类型（0：自然人 1：法人 2：非法人组织）
   */
  private String userType;

  /**
   * 名称(类别为法人/非法人组织时, 填单位名称)
   */
  private String userName;

  /**
   * 性别
   */
  private String sex;

  /**
   * 国籍
   */
  private String nationality;

  /**
   * 民族
   */
  private String nation;

  /**
   * 联系电话
   */
  private String phone;

  /**
   * 证件类型
   */
  private String cardType;

  /**
   * 证件号码（如身份证）
   */
  private String idCard;

  /**
   * 详细地址
   */
  private String address;

  /**
   * 信用代码
   */
  private String creditCode;

  /**
   * 代表人：法人代表|机构代表人
   */
  private String corporation;

}
