package com.beiming.odr.referee.dto.requestdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Data;


@Data
@ApiModel(description = "案件延期审批请求参数")
public class MediationExtendBatchApprovalReqDTO implements Serializable {

  private static final long serialVersionUID = 4521652881528725696L;

  /**
   * 批量案件延期数据集
   */
  @NotEmpty(message = "{delay.data.in.batch.cases.cannot.be.empty}")
  @ApiModelProperty(value = "延期申请数据集合", position = 0)
  private List<ExtendLawCaseReqDTO> extendLawCaseReqDTOs;

  /**
   * 审批意见：true=同意|false=不同意
   */
  @NotNull(message = "{approval.comments.are.not.allowed.to.be.empty}")
  @ApiModelProperty(value = "延期审批意见", position = 0)
  private Boolean isAgree;

}
